#!/usr/bin/env python
import RPi.GPIO as GPIO
from mfrc522 import SimpleMFRC522
import subprocess
import queue
import requests
import env
import time
import threading


def check_internet_connection():
    try:
        subprocess.check_output(["ping", "-c", "1", "8.8.8.8"])
        return True
    except subprocess.CalledProcessError:
        return False


def read_tag():
    try:
        while True:
            print('You can scan tag')
            rfid_id, text = reader.read()
            queue_create_card.put(rfid_id)
            time.sleep(3)
    finally:
        GPIO.cleanup()


def process_queue():
    while True:
        if queue_create_card.empty() or not check_internet_connection():
            time.sleep(2)
        else:
            rfid_id = queue_create_card.get()
            response = requests.get(env.domain_url+'/system/scan-card/create', params={
                'rfid_id': rfid_id,
                'api_key': env.api_key,
            })
            if response.status_code == 200:
                print('ok')
                GPIO.output(env.green_led, True)
                time.sleep(1)
                GPIO.output(env.green_led, False)
            else:
                print('nie')
                GPIO.output(env.red_led, True)
                time.sleep(1)
                GPIO.output(env.red_led, False)


GPIO.setmode(GPIO.BCM)
GPIO.setup(env.green_led, GPIO.OUT)
GPIO.setup(env.red_led, GPIO.OUT)
queue_create_card = queue.Queue()

reader = SimpleMFRC522()

t_read_tag = threading.Thread(target=read_tag, name='t_read_tag')
t_process_queue = threading.Thread(target=process_queue, name='t_process_queue')

t_read_tag.start()
t_process_queue.start()

t_read_tag.join()
t_process_queue.join()
